/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.util;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.structurecompass.StructureCompass;
import com.mrbysco.structurecompass.config.StructureConfig;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureUtil {
    public static List<ResourceLocation> getAvailableStructureList(Level level) {
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>();
        Registry configuredRegistry = level.m_5962_().m_175515_(Registry.f_122882_);
        configuredRegistry.m_6566_().forEach(location -> {
            if (!StructureUtil.isBlacklisted(location) && !structureList.contains(location)) {
                structureList.add((ResourceLocation)location);
            }
        });
        return structureList;
    }

    public static boolean isBlacklisted(ResourceLocation structureLocation) {
        if (structureLocation == null) {
            StructureCompass.LOGGER.error("Checking blacklist but fed location is null!");
            return false;
        }
        if (!((List)StructureConfig.COMMON.structureBlacklist.get()).isEmpty()) {
            if (((List)StructureConfig.COMMON.structureBlacklist.get()).contains(structureLocation.toString())) {
                return true;
            }
            List<String> wildcardList = ((List)StructureConfig.COMMON.structureBlacklist.get()).stream().filter(value -> value.contains(":") && value.contains("*")).toList();
            for (String wildcard : wildcardList) {
                String[] blacklistSplit = wildcard.split(":");
                if ((!blacklistSplit[0].equals("*") || !structureLocation.m_135815_().equals(blacklistSplit[1])) && (!blacklistSplit[1].equals("*") || !structureLocation.m_135827_().equals(blacklistSplit[0]))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> findNearestMapFeature(ServerLevel serverLevel, HolderSet<ConfiguredStructureFeature<?, ?>> featureHolderSet, BlockPos pos, int range, boolean locateUnexplored) {
        ChunkGenerator generator = serverLevel.m_7726_().m_8481_();
        Set set = featureHolderSet.m_203614_().flatMap(featureHolder -> ((ConfiguredStructureFeature)featureHolder.m_203334_()).m_209752_().m_203614_()).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return null;
        }
        Set set1 = generator.m_62218_().m_207840_();
        if (Collections.disjoint(set1, set)) {
            return null;
        }
        Pair pair = null;
        double locateRange = ((Integer)StructureConfig.COMMON.compassRange.get()).intValue();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Object holder : featureHolderSet) {
            if (set1.stream().noneMatch(arg_0 -> ((HolderSet)((ConfiguredStructureFeature)holder.m_203334_()).m_209752_()).m_203333_(arg_0))) continue;
            for (StructurePlacement structureplacement : generator.m_208090_((Holder)holder)) {
                map.computeIfAbsent(structureplacement, p_211663_ -> new ObjectArraySet()).add(holder);
            }
        }
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structureplacement1 = (StructurePlacement)entry.getKey();
            if (structureplacement1 instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement1;
                BlockPos blockpos = generator.m_204382_(pos, concentricringsstructureplacement);
                double d1 = pos.m_123333_((Vec3i)blockpos);
                if (!(d1 < locateRange)) continue;
                locateRange = d1;
                pair = Pair.of((Object)blockpos, (Object)((Holder)((Set)entry.getValue()).iterator().next()));
                continue;
            }
            if (!(structureplacement1 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int i = SectionPos.m_123171_((int)pos.m_123341_());
            int j = SectionPos.m_123171_((int)pos.m_123343_());
            for (int k = 0; k <= range; ++k) {
                boolean flag = false;
                for (Map.Entry entry1 : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry1.getKey();
                    Pair pair1 = ChunkGenerator.m_208059_((Set)((Set)entry1.getValue()), (LevelReader)serverLevel, (StructureFeatureManager)serverLevel.m_8595_(), (int)i, (int)j, (int)k, (boolean)locateUnexplored, (long)serverLevel.m_7328_(), (RandomSpreadStructurePlacement)randomspreadstructureplacement);
                    if (pair1 == null) continue;
                    flag = true;
                    double d2 = pos.m_123333_((Vec3i)pair1.getFirst());
                    if (!(d2 < locateRange)) continue;
                    locateRange = d2;
                    pair = pair1;
                }
                if (!flag) continue;
                return pair;
            }
        }
        return pair;
    }
}

